#ifndef UNLOCKED_IO_H
# define UNLOCKED_IO_H 1

#ifndef _REENTRANT
#define HAVE_CLEARERR_UNLOCKED 1
#define HAVE_FEOF_UNLOCKED 1
#define HAVE_FERROR_UNLOCKED 1
#define HAVE_FFLUSH_UNLOCKED 1
#define HAVE_FGETS_UNLOCKED 1
#define HAVE_FPUTC_UNLOCKED 1
#define HAVE_FPUTS_UNLOCKED 1
#define HAVE_FREAD_UNLOCKED 1
#define HAVE_FWRITE_UNLOCKED 1
#define HAVE_GETC_UNLOCKED 1
#define HAVE_GETCHAR_UNLOCKED 1
#define HAVE_PUTC_UNLOCKED 1
#define HAVE_PUTCHAR_UNLOCKED 1
#endif

#  if HAVE_CLEARERR_UNLOCKED
#   undef clearerr
#   define clearerr(x) clearerr_unlocked (x)
#  endif
#  if HAVE_FEOF_UNLOCKED
#   undef feof
#   define feof(x) feof_unlocked (x)
#  endif
#  if HAVE_FERROR_UNLOCKED
#   undef ferror
#   define ferror(x) ferror_unlocked (x)
#  endif
#  if HAVE_FFLUSH_UNLOCKED
#   undef fflush
#   define fflush(x) fflush_unlocked (x)
#  endif
#  if HAVE_FGETS_UNLOCKED
#   undef fgets
#   define fgets(x,y,z) fgets_unlocked (x,y,z)
#  endif
#  if HAVE_FPUTC_UNLOCKED
#   undef fputc
#   define fputc(x,y) fputc_unlocked (x,y)
#  endif
#  if HAVE_FPUTS_UNLOCKED
#   undef fputs
#   define fputs(x,y) fputs_unlocked (x,y)
#  endif
#  if HAVE_FREAD_UNLOCKED
#   undef fread
#   define fread(w,x,y,z) fread_unlocked (w,x,y,z)
#  endif
#  if HAVE_FWRITE_UNLOCKED
#   undef fwrite
#   define fwrite(w,x,y,z) fwrite_unlocked (w,x,y,z)
#  endif
#  if HAVE_GETC_UNLOCKED
#   undef getc
#   define getc(x) getc_unlocked (x)
#  endif
#  if HAVE_GETCHAR_UNLOCKED
#   undef getchar
#   define getchar() getchar_unlocked ()
#  endif
#  if HAVE_PUTC_UNLOCKED
#   undef putc
#   define putc(x,y) putc_unlocked (x,y)
#  endif
#  if HAVE_PUTCHAR_UNLOCKED
#   undef putchar
#   define putchar(x) putchar_unlocked (x)
#  endif

#endif /* UNLOCKED_IO_H */
