/*
Also glibc getline.
    http://mail.gnome.org/archives/gnome-list/2000-August/msg00123.html
    http://mail.python.org/pipermail/patches/2000-November/002880.html
Also mention fgets not writing beyond \0 caveat
Also mess around with setvbuf(stdin+stdout,..) to see how it affects things (info libc, s buffering)
*/
/* getline uses getc internally.
   includes \n & \0 on returned lines (doesn't auto add \n if not present @ EOF)
   lineptr & n can be NULL or malloced buffer.
   num chars in line (including \n) is returned so that embedded NULs can be handled.
*/

#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include "linebuffer.h"

int main(void)
{
#if GETLINE
    char* line;
    size_t line_len=0;
    ssize_t curr_line_len;

    while ((curr_line_len=getline(&line, &line_len, stdin))>0)
        fwrite(line, 1, curr_line_len, stdout);
    free(line);
#else
    struct linebuffer *line;
    line = (struct linebuffer*) malloc(sizeof(struct linebuffer));

    initbuffer(line);

#if NoNULLs
    while (readlineNoNulls(line, stdin))
        puts(line->buffer);
#else
    while (readline(line, stdin))
        fwrite(line->buffer, 1, line->length, stdout);
#endif

    freebuffer(line);
#endif
    return 0;
}
